#include <d3d9.h>
#include <math.h>

void DrawRotatedSpriteRectangle(IDirect3DDevice9* pDevice, float x0, float y0, float x1, float y1, float a, IDirect3DTexture9* pTexture)
{
    pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
    pDevice->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_STENCILENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_FOGENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
    pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
    pDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);

    pDevice->SetVertexShader(NULL);
    pDevice->SetFVF(D3DFVF_XYZRHW | D3DFVF_TEX1);

    struct Vertex
    {
        float x, y, z, rhw;
        float u, v;
    };

    float const x = (x0 + x1) / 2;
    float const y = (y0 + y1) / 2;
    float const xd = x1 - x;
    float const yd = y1 - y;

    float const cosa = cos(a);
    float const sina = sin(a);

    Vertex const vertices[4] =
    {
        { x - cosa * xd - sina * yd, y + sina * xd - cosa * yd, 0, 1, 0, 0 },
        { x + cosa * xd - sina * yd, y - sina * xd - cosa * yd, 0, 1, 1, 0 },
        { x - cosa * xd + sina * yd, y + sina * xd + cosa * yd, 0, 1, 0, 1 },
        { x + cosa * xd + sina * yd, y - sina * xd + cosa * yd, 0, 1, 1, 1 },
    };

    pDevice->SetTexture(0, pTexture);
    pDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT);
    pDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT);
    pDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, vertices, sizeof(vertices[0]));

    pDevice->SetTexture(0, NULL);
}

void DrawSpriteRectangle(IDirect3DDevice9* pDevice, float x0, float y0, float x1, float y1, IDirect3DTexture9* pTexture)
{
    pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
    pDevice->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_STENCILENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_FOGENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
    pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
    pDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);

    pDevice->SetVertexShader(NULL);
    pDevice->SetFVF(D3DFVF_XYZRHW | D3DFVF_TEX1);

    struct Vertex
    {
        float x, y, z, rhw;
        float u, v;
    };

    Vertex const vertices[4] =
    {
        { x0, y0, 0, 1, 0, 0 },
        { x1, y0, 0, 1, 1, 0 },
        { x0, y1, 0, 1, 0, 1 },
        { x1, y1, 0, 1, 1, 1 },
    };

    pDevice->SetTexture(0, pTexture);
    pDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT);
    pDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT);
    pDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, vertices, sizeof(vertices[0]));

    pDevice->SetTexture(0, NULL);
}

void DrawTexturedOpaqueRectangle(IDirect3DDevice9* pDevice, float x0, float y0, float x1, float y1, IDirect3DTexture9* pTexture)
{
    pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
    pDevice->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_STENCILENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_FOGENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
    pDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);

    pDevice->SetVertexShader(NULL);
    pDevice->SetFVF(D3DFVF_XYZRHW | D3DFVF_TEX1);

    struct Vertex
    {
        float x, y, z, rhw;
        float u, v;
    };

    Vertex const vertices[4] =
    {
        { x0, y0, 0, 1, 0, 0 },
        { x1, y0, 0, 1, 1, 0 },
        { x0, y1, 0, 1, 0, 1 },
        { x1, y1, 0, 1, 1, 1 },
    };

    pDevice->SetTexture(0, pTexture);
    pDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT);
    pDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT);
    pDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, vertices, sizeof(vertices[0]));

    pDevice->SetTexture(0, NULL);
}
