#pragma once

#include <stdlib.h>

struct IDirect3DTexture9;

struct Jewel
{
    float x;
    float y;
    float fallVelocity;

    IDirect3DTexture9* pTexture;
};

size_t const BoardWidth  = 10;
size_t const BoardHeight = 10;

struct Board
{
    Jewel jewels[BoardWidth][BoardHeight];
};

void InitializeBoard(Board& board, IDirect3DTexture9* const* jewelTextures, size_t numJewelTextures);

template < size_t N >
void InitializeBoard(Board& board, IDirect3DTexture9* const (&jewelTextures)[N])
{
    InitializeBoard(board, jewelTextures, N);
}

void SwapJewels(Board& board, size_t x0, size_t y0, size_t x1, size_t y1);
bool ResolveMatches(Board& board, IDirect3DTexture9* const* jewelTextures, size_t numJewelTextures);

template < size_t N >
bool ResolveMatches(Board& board, IDirect3DTexture9* const (&jewelTextures)[N])
{
    return ResolveMatches(board, jewelTextures, N);
}

struct HorizontalMatch
{
    size_t x;
    size_t y;
    size_t w;

    IDirect3DTexture9* pTexture;
};

HorizontalMatch GetHorizontalMatch(Board const& board, size_t x, size_t y);

struct VerticalMatch
{
    size_t x;
    size_t y;
    size_t h;

    IDirect3DTexture9* pTexture;
};

VerticalMatch GetVerticalMatch(Board const& board, size_t x, size_t y);

bool AnimateFallingJewels(float timeDelta, Board& board);
void AnimateJewelSwap(float time, Board& board, size_t x0, size_t y0, size_t x1, size_t y1);
