#pragma once

#include <Windows.h>
#include <d3d9.h>
#include <d3dx9.h>

D3DXCOLOR const D3DXWhite(1, 1, 1, 1);
D3DXCOLOR const D3DXBlack(0, 0, 0, 1);

D3DXCOLOR const D3DXWhiteA0(1, 1, 1, 0);
D3DXCOLOR const D3DXBlackA0(0, 0, 0, 0);

inline
D3DXCOLOR operator*(D3DXCOLOR const& c0, D3DXCOLOR const& c1)
{
    D3DXCOLOR const result(
        c0.r * c1.r,
        c0.g * c1.g,
        c0.b * c1.b,
        c0.a * c1.a);

    return result;
}

inline
D3DXCOLOR Min(D3DXCOLOR const& c0, D3DXCOLOR const& c1)
{
    return D3DXCOLOR(
        min(c0.r, c1.r),
        min(c0.g, c1.g),
        min(c0.b, c1.b),
        min(c0.a, c1.a));
}

inline
D3DXCOLOR Max(D3DXCOLOR const& c0, D3DXCOLOR const& c1)
{
    return D3DXCOLOR(
        max(c0.r, c1.r),
        max(c0.g, c1.g),
        max(c0.b, c1.b),
        max(c0.a, c1.a));
}

inline
D3DXCOLOR Saturate01(D3DXCOLOR const& c0)
{
    return D3DXCOLOR(
        min(max(c0.r, 0), 1),
        min(max(c0.g, 0), 1),
        min(max(c0.b, 0), 1),
        min(max(c0.a, 0), 1));
}

inline
D3DXMATRIX MatrixScaleYawPitchRollPos(D3DXVECTOR3 const& scale, float yaw, float pitch, float roll, D3DXVECTOR3 const& pos)
{
    D3DXMATRIX result;
    D3DXMATRIX s, r;

    D3DXMatrixScaling(&s, scale.x, scale.y, scale.z);
    D3DXMatrixRotationYawPitchRoll(&r, yaw, pitch, roll);
    D3DXMatrixMultiply(&result, &s, &r);
    result._41 = pos.x;
    result._42 = pos.y;
    result._43 = pos.z;

    return result;
}

inline
DWORD FloatToRawDWORD(float f)
{
    return *(DWORD const*)&f;
}