#include "DXUT.h"

#include "PostProcess.h"

namespace PostProcess
{
    #include "PostProcessPS.pfxobj"

    IDirect3DPixelShader9* g_PostProcessPS = 0;

    void Init(IDirect3DDevice9* pd3dDevice)
    {
        pd3dDevice->CreatePixelShader((DWORD const*)PFX_PostProcessPS, &g_PostProcessPS);
    }

    void Done()
    {
        SAFE_RELEASE(g_PostProcessPS);
    }

    void CopyFullscreen(IDirect3DDevice9* pd3dDevice, IDirect3DTexture9* pTexture)
    {
        struct CUSTOMVERTEX
        {
            FLOAT x, y, z, rhw; // The transformed position for the vertex.
            float u, v;         // The vertex color.
        };

        DWORD const D3DFVF_CUSTOMVERTEX = D3DFVF_XYZRHW | D3DFVF_TEX1;

        D3DVIEWPORT9 viewport;
        pd3dDevice->GetViewport(&viewport);

        float const width  = float(viewport.Width);
        float const height = float(viewport.Height);

        CUSTOMVERTEX const vertices[] =
        {
            {      -0.5f,       -0.5f, 1.0f, 1.0f, 0, 0, }, // x, y, z, rhw, u, v
            { width-0.5f,       -0.5f, 1.0f, 1.0f, 1, 0, },
            {      -0.5f, height-0.5f, 1.0f, 1.0f, 0, 1, },
            { width-0.5f, height-0.5f, 1.0f, 1.0f, 1, 1, },
        };

        pd3dDevice->SetVertexShader(NULL);
        pd3dDevice->SetPixelShader(NULL);
        pd3dDevice->SetFVF(D3DFVF_CUSTOMVERTEX);
        pd3dDevice->SetTexture(0, pTexture);
        pd3dDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
        pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
        pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
        pd3dDevice->SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);
        pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
        pd3dDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);
        pd3dDevice->SetRenderState(D3DRS_FOGENABLE, FALSE);
        pd3dDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
        pd3dDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
        pd3dDevice->SetSamplerState(0, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR);
        pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
        pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);
        pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG1);
        pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
        pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
        pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
        pd3dDevice->SetTextureStageState(1, D3DTSS_COLOROP, D3DTOP_DISABLE);
        pd3dDevice->SetTextureStageState(1, D3DTSS_ALPHAOP, D3DTOP_DISABLE);

        pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, vertices, sizeof(vertices[0]));

        pd3dDevice->SetTexture(0, NULL);
    }

    void CopyAntialias(IDirect3DDevice9* pd3dDevice, IDirect3DTexture9* pTexture)
    {
        struct CUSTOMVERTEX
        {
            FLOAT x, y, z, rhw; // The transformed position for the vertex.
            float u, v;         // The vertex color.
        };

        DWORD const D3DFVF_CUSTOMVERTEX = D3DFVF_XYZRHW | D3DFVF_TEX1;

        D3DVIEWPORT9 viewport;
        pd3dDevice->GetViewport(&viewport);

        float const width  = float(viewport.Width);
        float const height = float(viewport.Height);

        CUSTOMVERTEX const vertices[] =
        {
            {      -0.5f,       -0.5f, 1.0f, 1.0f, 0, 0, }, // x, y, z, rhw, u, v
            { width-0.5f,       -0.5f, 1.0f, 1.0f, 1, 0, },
            {      -0.5f, height-0.5f, 1.0f, 1.0f, 0, 1, },
            { width-0.5f, height-0.5f, 1.0f, 1.0f, 1, 1, },
        };

        D3DSURFACE_DESC textureDesc;
        pTexture->GetLevelDesc(0, &textureDesc);

        float const psConstants[4] =
        {
            1.0f / textureDesc.Width, 1.0f / textureDesc.Height, 0, 0,
        };
        pd3dDevice->SetPixelShaderConstantF(0, psConstants, 1);

        pd3dDevice->SetVertexShader(NULL);
        pd3dDevice->SetPixelShader(g_PostProcessPS);
        pd3dDevice->SetFVF(D3DFVF_CUSTOMVERTEX);
        pd3dDevice->SetTexture(0, pTexture);
        pd3dDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
        pd3dDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
        pd3dDevice->SetSamplerState(0, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR);
        pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
        pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

        pd3dDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
        pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
        pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
        pd3dDevice->SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);
        pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
        pd3dDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);
        pd3dDevice->SetRenderState(D3DRS_FOGENABLE, FALSE);

        pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, vertices, sizeof(vertices[0]));

        pd3dDevice->SetTexture(0, NULL);
        pd3dDevice->SetPixelShader(NULL);
    }
}
