/*
	Chase Camera 

	Copyright (c) 2007 Dan Chang. All rights reserved. 

    This software is provided "as is" without express or implied 
    warranties. You may freely copy and compile this source into 
    applications you distribute provided that the copyright text 
    below is included in the resulting source code, for example: 
    "Portions Copyright (c) 2007 Dan Chang" 
 */

#include "DXUT.h"
#include "ChaseCamera.h"
#include "body.h"
#include "database.h"
#include "Game.h"
#include "gameobject.h"
#include "global.h"
#include "Tiny.h"

const float fRotateSpeed = 1.0f;            // chase camera rotation speed 
const float fMoveSpeed = 5.0f;              // chase camera move speed 

//--------------------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------------------
CChaseCamera::CChaseCamera()
{
}

//--------------------------------------------------------------------------------------
// Destructor
//--------------------------------------------------------------------------------------
CChaseCamera::~CChaseCamera()
{
}

//--------------------------------------------------------------------------------------
// Call this from your message proc so this class can handle window messages
//--------------------------------------------------------------------------------------
LRESULT CChaseCamera::HandleMessages( HWND , UINT , WPARAM , LPARAM )
{
    return FALSE;
}

//--------------------------------------------------------------------------------------
// Update the view matrix based on user input & elapsed time
//--------------------------------------------------------------------------------------
VOID CChaseCamera::FrameMove( FLOAT fElapsedTime )
{
    // set follow transforms
	GameObject* player = g_database.Find(g_objectIDPlayer);
	CInstance * pChar = player->GetInstance();

    D3DXVECTOR3 vCharPos = pChar->GetOwner()->GetBody().GetPos();
    D3DXVECTOR3 vCharFacing = pChar->GetOwner()->GetBody().GetDir();
    m_vEye = D3DXVECTOR3( vCharPos.x, 4.f * 0.25f, vCharPos.z );
    m_vLookAt = D3DXVECTOR3( vCharPos.x, 4.f * 0.0125f, vCharPos.z );
    D3DXVECTOR3 vUp( 0.0f, 1.0f, 0.0f );
    vCharFacing.x *= 4.f * .25; vCharFacing.y = 0.f; vCharFacing.z *= 4.f * .25;
    m_vEye -= vCharFacing;
    m_vLookAt += vCharFacing;

    // Update the view matrix
    D3DXMatrixLookAtLH( &m_mView, &m_vEye, &m_vLookAt, &vUp );

    D3DXMatrixInverse( &m_mCameraWorld, NULL, &m_mView );
}
