//-----------------------------------------------------------------------------
// File: MeshInstance.cpp
//
// Desc: Defines the mesh instance class. 
//       It holds an instance of a mesh to draw and a transform matrix 
//       that specifies where to draw that mesh. 
//
// Copyright (c) Dan Chang. All rights reserved. 
//
// This software is provided "as is" without express or implied
// warranties. You may freely copy and compile this source into
// applications you distribute provided that the copyright text
// below is included in the resulting source code, for example:
// "Portions Copyright (c) Dan Chang"
//-----------------------------------------------------------------------------

#include "DXUT.h"
#include "body.h"
#include "configure.h"
#include "GameError.h"
#include "gameobject.h"
#include "MeshInstance.h"
#include "ModelNode.h"
#include "TransNode.h"

CMeshInstance::CMeshInstance(GameObject& owner) : 
	CInstance(owner)
{
}

CMeshInstance::~CMeshInstance()
{
}


HRESULT CMeshInstance::GetInstance(IDirect3DDevice9* pd3dDevice, const LPCWSTR szFilename)
{
	OnDestroyDevice();

	ModelNode* pmn = new ModelNode(pd3dDevice);
	HRESULT hr = pmn->GetInstance(szFilename);
	if (FAILED(hr))
	{
		PrintfError(L"Error getting instance of %s.", szFilename);
		return hr;
	}
	m_pNode = std::tr1::shared_ptr<Node>(pmn);

	return MAKE_HRESULT(SEVERITY_SUCCESS, 0, 0);
}


void CMeshInstance::OnDestroyDevice()
{
	if (m_pNode)
	{
		m_pNode->OnDestroyDevice();
	}
}


//-----------------------------------------------------------------------------
// Name: CMeshInstance::ResetTime()
// Desc: Resets the local time for this CMeshInstance.
//-----------------------------------------------------------------------------
HRESULT CMeshInstance::ResetTime()
{
    return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CMeshInstance::AdvanceTime()
// Desc: Advances the local animation time by dTimeDelta. 
//-----------------------------------------------------------------------------
HRESULT CMeshInstance::AdvanceTime( double /* dTimeDelta */, const D3DXVECTOR3& /* vEye */ )
{
	return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CMeshInstance::Draw()
// Desc: Draws this CMeshInstance.
//-----------------------------------------------------------------------------
HRESULT CMeshInstance::Draw( IDirect3DDevice9* /*pd3dDevice*/, D3DXMATRIX /*matWorld*/ )
{
	return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CMeshInstance::SetOrientation()
// Desc: Copy the orientation from Body to the Node. 
//-----------------------------------------------------------------------------
void CMeshInstance::SetOrientation()
{
	D3DXMATRIX mxWorld;
	m_owner->GetBody().GetMatrix(&mxWorld);
	TransNode* ptn = reinterpret_cast<TransNode*>(m_pNode.get());
	if (ptn)
	{
		*ptn->GetMatrix() = mxWorld;
	}
}


HRESULT CMeshInstance::OnCreateDevice( LPDIRECT3DDEVICE9 /* pd3dDevice */ )
{
	return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CMeshInstance::OnResetDevice()
// Desc: Reinitialize necessary objects.
//-----------------------------------------------------------------------------
HRESULT CMeshInstance::OnResetDevice( LPDIRECT3DDEVICE9 /* pd3dDevice */ )
{
	return S_OK;
}


HRESULT CMeshInstance::OnLostDevice()
{
	return S_OK;
}
