#pragma once
#include <vector>

////////////////////////////////////////////////////////////////////////////


class Node
{
public:
						Node(IDirect3DDevice9* pd3dDevice);
	virtual				~Node();

	virtual HRESULT		GetInstance(const LPCWSTR szFilename);

	// Update traversal for physics, AI, etc.
	virtual void		Update(double fTime);

						// Render traversal for drawing objects
	virtual void		Render(IDirect3DDevice9* pd3dDevice, D3DXMATRIX matWorld);

	// Most classes that inherit from Node need to implement only either 
	// OnCreateDevice() and OnDestroyDevice(), or OnResetDevice() and OnLostDevice(). 
	// Resources using D3DPOOL_MANAGED should use OnCreateDevice() / OnDestroyDevice(), and 
	// resources using D3DPOOL_DEFAULT should use OnResetDevice() / OnLostDevice(). 
	// If you use D3DPOOL_DEFAULT with OnCreateDevice() / OnDestroyDevice(), the symptom 
	// is you'll see memory leaks on exit after toggling between windowed and full-screen modes. 

	virtual void		OnCreateDevice(IDirect3DDevice9* pd3dDevice);
	virtual void		OnResetDevice(IDirect3DDevice9* pd3dDevice);
	virtual void		OnLostDevice();
	virtual void		OnDestroyDevice();

						// Hierarchy management
	int					GetNumChildren()			{return m_vecpChildren.size();}
	std::tr1::shared_ptr<Node> GetChild(int iChild)	{return m_vecpChildren[iChild];}
	void				AddChild(std::tr1::shared_ptr<Node> pNode);

protected:
	std::vector<std::tr1::shared_ptr<Node> >	m_vecpChildren;
};


////////////////////////////////////////////////////////////////////////////
